#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define MAXN 300000
#define PI 3.14159265358979323846

typedef long long ll;

typedef struct {
    double ang;
    ll x, y;
    int idx;
} Vec;

Vec v[2 * MAXN];
int n;

int cmp(const void *a, const void *b) {
    double d = ((Vec*)a)->ang - ((Vec*)b)->ang;
    if (d < 0) return -1;
    if (d > 0) return 1;
    return 0;
}

int main() {
    int i, l, r;
    ll sx, sy, best, cur;
    int best_l, best_r;

    if (scanf("%d", &n) != 1) return 0;

    for (i = 0; i < n; i++) {
        scanf("%lld %lld", &v[i].x, &v[i].y);
        v[i].ang = atan2((double)v[i].y, (double)v[i].x);
        v[i].idx = i + 1;
    }

    qsort(v, n, sizeof(Vec), cmp);

    for (i = 0; i < n; i++) {
        v[i + n] = v[i];
        v[i + n].ang += 2 * PI;
    }

    sx = 0;
    sy = 0;
    best = 0;
    best_l = 0;
    best_r = -1;

    l = 0;
    for (r = 0; r < 2 * n; r++) {
        sx += v[r].x;
        sy += v[r].y;

        while (v[r].ang - v[l].ang > PI) {
            sx -= v[l].x;
            sy -= v[l].y;
            l++;
        }

        cur = sx * sx + sy * sy;
        if (cur > best) {
            best = cur;
            best_l = l;
            best_r = r;
        }
    }

    printf("%d\n", best_r - best_l + 1);
    for (i = best_l; i <= best_r; i++)
        printf("%d ", v[i].idx);
    printf("\n");

    return 0;
}